/* - PHDetachListener -
 * Clear the fields and disable the modify sensitivity textbox so that
 * new sensity value can't be sent while there is no device attached, otherwise 
 * this would generate a PhidgetException
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.PHSensorPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PHDetachListener implements DetachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField phTxt;
    private JLabel PHRngLbl;
    private JTextField potTxt;
    private JLabel potentialRngLbl;
    private JTextField sensitivityTxt;
    private JTextField tempTxt;
    
    /** Creates a new instance of PHDetachListener */
    public PHDetachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField phTxt,
            JLabel PHRngLbl, JTextField potTxt, JLabel potentialRngLbl, 
            JTextField sensitivityTxt, JTextField tempTxt)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.phTxt = phTxt;
        this.PHRngLbl = PHRngLbl;
        this.potTxt = potTxt;
        this.potentialRngLbl = potentialRngLbl;
        this.sensitivityTxt = sensitivityTxt;
        this.tempTxt = tempTxt;
    }

    public void detached(DetachEvent de)
    {
        try
        {
            PHSensorPhidget detached = (PHSensorPhidget)de.getSource();
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");
            phTxt.setText("");
            PHRngLbl.setText("");
            potTxt.setText("");
            potentialRngLbl.setText("");
            sensitivityTxt.setEnabled(false);
            sensitivityTxt.setText("");
            tempTxt.setEnabled(false);
            tempTxt.setText("");
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
